<?php

// Muestra todos los errores durante el desarrollo
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Carga el autoloader de Composer
require_once __DIR__ . '/../vendor/autoload.php';

// Importación de clases
use App\Core\Router;
use App\Controllers\HomeController;
use App\Controllers\AuthController;
use App\Controllers\DashboardController;
use App\Controllers\AtencionController;
use App\Controllers\ReportController;

// Instanciamos el router
$router = new Router();

// --- Definición de Rutas ---

// Ruta raíz ('/') ahora manejada por HomeController
$router->get('/', [HomeController::class, 'index']);

// Rutas de autenticación
$router->get('/login', [AuthController::class, 'showLoginForm']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/logout', [AuthController::class, 'logout']);

// Rutas de la API para atenciones
$router->post('/atenciones/crear', [AtencionController::class, 'crear']);
$router->get('/atenciones/detalle', [AtencionController::class, 'verDetalle']);

// Rutas para la generación de reportes
$router->get('/reporte/pdf/{fecha}', [ReportController::class, 'generatePdf']);
$router->get('/reporte/pdf/semanal/{fecha}', [ReportController::class, 'generateWeeklyPdf']); // <-- RUTA AÑADIDA
$router->get('/reporte/excel/{fecha}', [ReportController::class, 'generateExcel']);

// Ruta del panel principal
$router->get('/dashboard', [DashboardController::class, 'index']);


// El router procesa la petición actual
$router->dispatch();
