<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Dashboard de gestión para barberos - BarberTrack">
    <title>Dashboard - BarberTrack</title>
    <link rel="icon" href="/ruta/a/tu/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="/leonel/public/css/style.css"> 
    <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
</head>
<body class="dashboard-body">
    <div class="dashboard-container">
       <header class="main-header">
            <div class="header-greeting">
                <h1>Resumen General</h1>
                <p>Hola, <?= htmlspecialchars(explode(' ', $userName)[0]) ?>. Bienvenido a tu espacio de trabajo.</p>
            </div>
            <div class="header-actions">
                <?php
                    // --- LÓGICA PARA MOSTRAR EL BOTÓN SOLO LOS DOMINGOS ---
                    // Establece la zona horaria de Perú
                    date_default_timezone_set('America/Lima');
                    // Comprueba si el día actual es domingo (0)
                    if (date('w') == 0):
                ?>
                <a href="#" class="logout-button whatsapp-weekly" id="share-weekly-report-btn" title="Compartir Reporte Semanal">
                    <i class="ri-whatsapp-line"></i>
                    <span>Reporte Semanal</span>
                </a>
                <?php endif; ?>

                <a href="/leonel/public/logout" class="logout-button">
                    <i class="ri-logout-box-r-line"></i>
                    <span>Cerrar Sesión</span>
                </a>
            </div>
        </header>

        <div class="stats-panel">
            <div class="stat-card">
                <div class="stat-info">
                    <div class="title">GANANCIA DE HOY</div>
                    <div class="value">S/ <?= number_format($gananciaHoy, 2, '.', '') ?></div>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-info">
                    <div class="title">GANANCIA SEMANAL</div>
                    <div class="value">S/ <?= number_format($gananciaSemana, 2, '.', '') ?></div>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-info">
                    <div class="title">GANANCIA MENSUAL</div>
                    <div class="value">S/ <?= number_format($gananciaMes, 2, '.', '') ?></div>
                </div>
            </div>
        </div>

        <div class="records-section-header">
            <h2>Historial de Registros</h2>
            <div class="search-bar">
                <i class="ri-search-line"></i>
                <input type="text" id="date-search" placeholder="Buscar en registros...">
            </div>
        </div>
        
        <div class="day-cards-grid">
            <?php if (empty($resumen_dias)): ?>
                <div class="no-records-container">
                    <i class="ri-file-list-3-line"></i>
                    <h3>No hay registros todavía</h3>
                    <p>Presiona el botón '+' para añadir tu primer servicio.</p>
                </div>
            <?php else: ?>
                <?php foreach ($resumen_dias as $dia): ?>
                    <div class="day-card">
                        <div class="card-content" data-date="<?= $dia['fecha'] ?>">
                            <div class="card-date">
                                <?php 
                                    $dateObj = new DateTime($dia['fecha']);
                                    $formatter = new IntlDateFormatter('es_ES', IntlDateFormatter::MEDIUM, IntlDateFormatter::NONE, null, null, 'd MMM yyyy');
                                    $fecha_formateada = ($dia['fecha'] == date('Y-m-d')) ? 'Hoy' : (($dia['fecha'] == date('Y-m-d', strtotime('-1 day'))) ? 'Ayer' : $formatter->format($dateObj));
                                    echo $fecha_formateada;
                                ?>
                            </div>
                            <div class="card-total">S/ <?= number_format($dia['total_ganado'], 2, '.', '') ?></div>
                            <div class="card-subtitle"><?= $dia['numero_registros'] ?> registros</div>
                        </div>
                        <div class="card-actions">
                            <!-- BOTONES ACTUALIZADOS -->
                            <a href="#" class="card-action-btn whatsapp" data-date="<?= $dia['fecha'] ?>" title="Compartir por WhatsApp"><i class="ri-whatsapp-line"></i></a>
                            <a href="/leonel/public/reporte/pdf/<?= $dia['fecha'] ?>" target="_blank" class="card-action-btn pdf" title="Exportar PDF"><i class="ri-file-pdf-line"></i></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <p id="no-results-message" style="display: none;">No se encontraron registros para tu búsqueda.</p>
    </div>

    <button id="fab-add-record" class="fab" title="Registrar Nuevo Servicio"><i class="ri-add-line"></i></button>

    <!-- Modal de Registro (sin cambios) -->
    <div id="registerModal" class="modal-overlay">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Nuevo Registro</h2>
                <button class="close-modal-btn"><i class="ri-close-line"></i></button>
            </div>
            <div class="modal-body">
                <div class="form-section">
                    <label>Servicios</label>
                    <ul class="service-list">
                        <?php foreach ($servicios as $servicio): ?>
                            <li class="service-item" data-id="<?= $servicio['id'] ?>" data-amount="<?= number_format($servicio['monto_ganancia'], 2, '.', '') ?>">
                                <span class="service-name"><?= htmlspecialchars($servicio['nombre']) ?></span>
                                <span class="service-price">S/ <?= number_format($servicio['monto_ganancia'], 2, '.', '') ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="form-section">
                    <label for="commissionAmount">Comisión por Venta</label>
                    <input type="number" id="commissionAmount" placeholder="S/ 0.00" min="0" step="0.50">
                </div>
            </div>
            <div class="modal-footer">
                <div class="total-preview">
                    <span>Ganancia de la atención:</span>
                    <strong id="modal-total">S/ 0.00</strong>
                </div>
                <button id="submitRegistration" class="btn-primary">
                    <i class="ri-check-line"></i>
                    <span>Registrar Ganancia</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Modal de Detalles (sin cambios) -->
    <div id="detailsModal" class="modal-overlay">
        <div class="modal-content">
            <div class="modal-header">
                <h2 id="detailsModalTitle">Detalle del Día</h2>
                <button class="close-modal-btn"><i class="ri-close-line"></i></button>
            </div>
            <div id="detailsModalBody" class="modal-body"></div>
        </div>
    </div>
  <div id="whatsappModal" class="modal-overlay">
    <div class="modal-content">
        <div class="modal-header">
            <!-- VERIFICA QUE ESTA LÍNEA TENGA EL ID CORRECTO -->
            <h2 id="whatsappModalTitle">Compartir por WhatsApp</h2>
            <button class="close-modal-btn"><i class="ri-close-line"></i></button>
        </div>
            <div class="modal-body">
                <div class="form-section">
                    <label for="whatsappNumber">Número de celular (Perú)</label>
                    <div class="phone-input-group">
                        <span class="country-code">+51</span>
                        <input type="tel" id="whatsappNumber" placeholder="987 654 321" maxlength="9">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button id="sendWhatsappBtn" class="btn-primary">
                    <i class="ri-send-plane-fill"></i>
                    <span>Enviar Reporte</span>
                </button>
            </div>
        </div>
    </div>

    <script src="/leonel/public/js/app.js"></script>
</body>
</html>
