<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - BarberTrack</title>
    
    <link rel="stylesheet" href="/leonel/public/css/style.css">
    <link rel="manifest" href="/leonel/public/manifest.json">
<!-- Opcional: Color de la barra de estado en iOS -->
<meta name="apple-mobile-web-app-status-bar-style" content="#B98D58">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body class="login-body">

    <div class="login-container">
        <h2>Iniciar Sesión en BarberTrack</h2>

        <?php
        // Muestra el mensaje de error si existe en la sesión
        // Tu CSS necesita una regla para la clase ".error-message" para que se vea bien
        if (isset($_SESSION['error_message'])) {
            echo '<p class="error-message">' . htmlspecialchars($_SESSION['error_message']) . '</p>';
            unset($_SESSION['error_message']);
        }
        ?>

        <form action="/leonel/public/login" method="POST" novalidate>
            <div class="form-group">
                <label for="usuario">Usuario</label>
                <input type="text" id="usuario" name="usuario" required>
            </div>
            <div class="form-group">
                <label for="contrasena">Contraseña</label>
                <input type="password" id="contrasena" name="contrasena" required>
            </div>
            <button type="submit">Ingresar</button>
        </form>
    </div>

</body>
</html>