<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Usuario
{
    private PDO $db;

    public function __construct()
    {
        // Obtenemos la conexión a la base de datos
        $this->db = Database::getInstance()->getConnection();
    }

    /**
     * Busca un usuario por su nombre de usuario.
     * @param string $username
     * @return mixed Devuelve un array con los datos del usuario si lo encuentra, o false si no.
     */
    public function findByUsername(string $username): mixed
    {
        try {
            $stmt = $this->db->prepare("SELECT * FROM usuarios WHERE nombre_usuario = :username LIMIT 1");
            $stmt->bindParam(':username', $username);
            $stmt->execute();
            
            return $stmt->fetch(); // fetch() devuelve false si no hay resultados
        } catch (\PDOException $e) {
            // Manejo de errores (en un proyecto real, loguear el error)
            return false;
        }
    }
}