<?php

namespace App\Core;

use PDO;
use PDOException;

class Database
{
    // Parámetros de conexión
    private const DB_HOST = '50.116.27.100';
    private const DB_NAME = 'romarqte_leonel';
    private const DB_USER = 'romarqte_leonel'; // Cambia esto por tu usuario de BD
    private const DB_PASS = 'C%_lGDUBDwQM';     // Cambia esto por tu contraseña de BD
    
    private static ?self $instance = null;
    private PDO $connection;

    private function __construct()
    {
        $dsn = 'mysql:host=' . self::DB_HOST . ';dbname=' . self::DB_NAME . ';charset=utf8mb4';
        
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Devuelve resultados como arrays asociativos
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];

        try {
            $this->connection = new PDO($dsn, self::DB_USER, self::DB_PASS, $options);
        } catch (PDOException $e) {
            // En un entorno de producción, nunca muestres errores detallados.
            // Guárdalos en un log.
            throw new PDOException("Error de conexión: " . $e->getMessage());
        }
    }

    /**
     * Obtiene la instancia única de la base de datos (Singleton).
     */
    public static function getInstance(): self
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Obtiene el objeto de conexión PDO.
     */
    public function getConnection(): PDO
    {
        return $this->connection;
    }

    // Prevenimos la clonación y la deserialización de la instancia.
    private function __clone() {}
    public function __wakeup() {}
}