<?php

namespace App\Controllers;

class HomeController
{
    /**
     * Punto de entrada principal de la aplicación.
     * Redirige al dashboard si el usuario está autenticado,
     * o a la página de login si no lo está.
     */
    public function index()
    {
        // Inicia o reanuda la sesión
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        // Comprueba si existe la variable de sesión del usuario
        if (isset($_SESSION['user_id'])) {
            // Si está logueado, redirige al dashboard
            header('Location: /leonel/public/dashboard');
        } else {
            // Si no, redirige al login
            header('Location: /leonel/public/login');
        }
        // Es importante terminar el script después de una redirección
        exit();
    }
}