<?php

namespace App\Controllers;

use App\Models\Servicio; // Importamos el nuevo modelo
use App\Models\Atencion; // ¡Importante!

class DashboardController
{
    public function __construct()
    {
        session_start();
        if (!isset($_SESSION['user_id'])) {
            header('Location: /leonel/public/login');
            exit();
        }
    }

   public function index()
{
    $servicioModel = new Servicio();
    $atencionModel = new Atencion();
    $userId = $_SESSION['user_id'];
    
    $data = [
        'userName' => $_SESSION['user_name'],
        'servicios' => $servicioModel->getAllActive(),
        'resumen_dias' => $atencionModel->getResumenGanancias($userId, 30),
        // --- NUEVOS DATOS PARA LAS ESTADÍSTICAS ---
        'gananciaHoy' => $atencionModel->getGananciaHoy($userId),
        'gananciaSemana' => $atencionModel->getGananciaSemana($userId),
        'gananciaMes' => $atencionModel->getGananciaMes($userId)
    ];
    
    $this->view('dashboard/index', $data);
}
    // ... (la función view se queda igual) ...
    protected function view(string $path, array $data = []){
        extract($data);
        $viewPath = __DIR__ . "/../Views/{$path}.php";
        if (file_exists($viewPath)) {
            require __DIR__ . '/../Views/layouts/main.php';
        } else {
            echo "Error: Vista no encontrada - {$viewPath}";
        }
    }
}