<?php

namespace App\Controllers;

use App\Models\Usuario;

class AuthController
{
    /**
     * Muestra el formulario de login.
     */
    public function showLoginForm()
    {
        // Inicia la sesión para poder mostrar mensajes de error si existen
        session_start();
        $this->view('auth/login');
    }

    /**
     * Procesa los datos del login.
     */
    public function login()
    {
        session_start();
        
        $username = $_POST['usuario'] ?? '';
        $password = $_POST['contrasena'] ?? '';

        $userModel = new Usuario();
        $user = $userModel->findByUsername($username);

        // Verificamos si el usuario existe y si la contraseña es correcta
        // NOTA: Como pediste no hashear, comparamos directamente.
        if ($user && $password === $user['contrasena']) {
            // ¡Login exitoso! Guardamos datos en la sesión.
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['nombre_completo'];
            
            // Redirigimos al dashboard
            header('Location: /leonel/public/dashboard');
            exit();
        } else {
            // Login fallido. Guardamos un mensaje de error y redirigimos de vuelta.
            $_SESSION['error_message'] = 'Usuario o contraseña incorrectos.';
            header('Location: /leonel/public/login');
            exit();
        }
    }

    /**
     * Cierra la sesión del usuario.
     */
    public function logout()
    {
        session_start();
        session_unset();
        session_destroy();
        header('Location: /leonel/public/login');
        exit();
    }
    
    /**
     * Función helper para cargar vistas (no necesita cambios).
     */
    protected function view(string $path, array $data = [])
    {
        extract($data);
        $viewPath = __DIR__ . "/../Views/{$path}.php";
        if (file_exists($viewPath)) {
            require __DIR__ . '/../Views/layouts/main.php';
        } else {
            echo "Error: Vista no encontrada - {$viewPath}";
        }
    }
}