<?php

namespace App\Controllers;

use App\Models\Atencion;

class AtencionController
{
    public function crear()
    {
        // Asegurarse de que el usuario está logueado
        session_start();
        if (!isset($_SESSION['user_id'])) {
            http_response_code(403); // Forbidden
            echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
            return;
        }

        // Leer los datos JSON enviados desde JavaScript
        $data = json_decode(file_get_contents('php://input'), true);

        $serviciosIds = $data['servicios'] ?? [];
        $comision = $data['comision'] ?? 0;
        $userId = $_SESSION['user_id'];

        $atencionModel = new Atencion();
        $resultado = $atencionModel->crearRegistroCompleto($userId, $serviciosIds, $comision);

        // Enviar respuesta JSON al frontend
        header('Content-Type: application/json');
        echo json_encode($resultado);
    }

    public function verDetalle()
{
    session_start();
    if (!isset($_SESSION['user_id'])) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
        return;
    }
    
    // La fecha vendrá como un parámetro GET, ej: /atenciones/detalle?fecha=2025-08-24
    $fecha = $_GET['fecha'] ?? null;
    if (!$fecha) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Fecha no proporcionada.']);
        return;
    }

    $atencionModel = new Atencion();
    $detalle = $atencionModel->getDetallePorFecha($_SESSION['user_id'], $fecha);
    
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'detalle' => $detalle]);
}
}